function(                                                      # CHECK IF STIMULI ARE CONTAINED IN VOCAB
         df=factor(levels=dataframes(eN))[[1]],                        # Stimulus Set               # Dataframe
         df_key=factor(eN_dollar_set(df),levels=colnames(df)),         # Stimulus Set               # Column containing word stimuli to be checked
         show=factor("Stimuli not in vocabulary",levels=c("Stimuli not in vocabulary","Stimuli in vocabulary","All stimuli"))[[1]],        # Stimulus Set              # Which items to show in results
         y=factor(eN[eN_stimulus_set(df)],levels=dataframes(eN))[[1]], # Vocabulary                 # Dataframe
         y_key=factor(eN_dollar_arg(df),levels=colnames(y))           # Vocabulary                 # Column containing words in vocabulary
) 
{
  tryCatch(
    {   
        if(length(df_key)!=length(y_key))
        {
          return(df)
        }
        xdup<-duplicated(df_key)
        if(any(xdup))
        {
          df_key<-df_key[!xdup]
          y_key<-y_key[!xdup]
        }
        ydup<-duplicated(y_key)
        if(any(ydup))
        {
          df_key<-df_key[!ydup]
          y_key<-y_key[!ydup]
        }
        m<-merge(df,y,by.x=df_key,by.y=y_key,all.x=TRUE,all.y=FALSE,sort=FALSE,suffixes=paste(".",sep="",c(deparse(substitute(df)),deparse(substitute(y)))) )
        if (show=="Stimuli in vocabulary") {m <- na.omit(m)} else if (show=="Stimuli not in vocabulary") m <- m[rowSums(is.na(m)) > 0,]
        return(m)
    }, warning = function(w) { print(w); return
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
      
    }, finally = { 
      
    }
  )  
}
