function(                                                      # COMPARE COLUMNS OF DATAFRAME BY NAME
         df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame to plot
         columns=factor(NULL,levels=colnames(df)),  # Dataframe                       # columns to show
         name="comparison"				# Dataframe		# New column name
) {
  tryCatch(
    {  
      if(is.null(columns)) return(df);
      check<-logical(nrow(df))
      check[1:nrow(df)]<-T
      if(length(columns)>1)
      {
        for(i in 2:length(columns))
        check <- check & df[[columns[1]]]==df[[columns[i]]]
      }
      df[[name]]<-check
      df
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
  
}
