function(                                             # CREATE A VOCABULARY FILE FOR A SELECTED MODEL
        df=factor(levels=dataframes(eN))[[1]],        # Settings                      # data frame containing words to include in vocabulary
        words=factor(NULL,levels=colnames(df))[[1]],  # Settings                      # column containing words
        freq=factor(NULL,levels=colnames(df))[[1]],   # Settings                      # column containing word frequency info
        model=factor(NULL,levels=c("ia","ia88","scm"))[[1]], # Settings               # model class (ia includes original ia, bia, rpm-ia, oob-ia; ia88 gives resting activities as in PDP book)
        language="",                                  # Settings                      # language of words (leave blank for models other than bia)
        mf=0.35,                                      # Settings                      # masking field parameter (only relevant to scm)
        filename=""                                   # Settings                      # name of vocab file to create (default location is Databases/Vocab_files/)
) {
  tryCatch(
    {  
      if(is.null(model)) { err<-data.frame(error=as.character("Model not specified"));err$error=as.character(err$error); return(err)}
      if(length(model)==0) { err<-data.frame(error=as.character("Model not specified"));err$error=as.character(err$error); return(err)}
      if(model=="") { err<-data.frame(error=as.character("Model not specified"));err$error=as.character(err$error); return(err)}

      if(is.null(freq)) { df$freq=1; freq="freq"} # { err<-data.frame(error=as.character("freq column not specified"));err$error=as.character(err$error); return(err)} # 
      if(length(freq)==0) { df$freq=1; freq="freq"} # { err<-data.frame(error=as.character("freq column not specified"));err$error=as.character(err$error); return(err)} # 
      if(freq=="") { df$freq=1; freq="freq"} # { err<-data.frame(error=as.character("freq column not specified"));err$error=as.character(err$error); return(err)} # 

      if(is.null(words)) { err<-data.frame(error=as.character("words column not specified"));err$error=as.character(err$error); return(err)}
      if(length(words)==0) { err<-data.frame(error=as.character("words column not specified"));err$error=as.character(err$error); return(err)}
      if(words=="") { err<-data.frame(error=as.character("words column not specified"));err$error=as.character(err$error); return(err)}

      if ((mf=="") || (mf<0) || is.na(mf) || is.null(mf)) mf<-0.35 # default value
#      return(data.frame(pos=16))
      
      get.resting.act<-function(df)
      {
#        return(data.frame(pos=20))         # exclude any words with non-positive freq
        df<-df[df[,freq]>0,]
        df$logf<-log(df[,freq])
        df$Rest=NA
        highest <- which(df$logf==max(df$logf))
        if (length(highest)==nrow(df)) M<-max(df$logf) else M<-max(df$logf[-highest])
        m<-min(df$logf)
        if ((M-m)==0) df$Rest=0 else df$Rest=.91*(df$logf-M)/(M-m) - .01
        df$Rest[which(df$logf==max(df$logf))]=0
        df[,freq]<-NULL
        df$logf<-NULL
        return(df)
      }
      
      get.resting.act2<-function(df)
      {
        # exclude any words with non-positive freq
        df<-df[df[,freq]>0,]
        df$logf<-log(log(df[,freq]+1))
        df$Rest=NA
        M<-max(df$logf[-which(df$logf==max(df$logf))])
        m<-min(df$logf)
        df$Rest=(.9262-.0179)*(df$logf-M)/(M-m) - .0179
        df$Rest[which(df$logf==max(df$logf))]=0
        df[,freq]<-NULL
        df$logf<-NULL
        return(df)
      }
      
      if (model=="ia88") {
        df<-get.resting.act2(df[,c(words,freq)])
      } else df<-get.resting.act(df[,c(words,freq)])
      
      names(df)[1:2]<-c("Word","Rest")
      if (language!="") {
        df$Language=language
      }
      if (model=="scm") {
        df$MF<-1+mf*(nchar(df$Word)-4)
        df$RMF<-1/df$MF
        df$Decision<-"yes"
      }
      
      # now write file
      if (filename!="") {
        if (length(grep("Databases/Vocab_files/",filename))==0) filename<-paste0("Databases/Vocab_files/",filename)
        write.table(df,filename,quote=F,row.names = F)
      }
      
      df
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
  
}
