function(                                                      # REPORT MATCH VALUES
         df=factor(levels=dataframes(eN))[[1]],                # Settings                      # data frame containing input values
         elm=factor("TRUE",levels=c("TRUE","FALSE"))[[1]],     # Settings                      # Assume end-letter marking?  
         sort.order=factor("none",levels=c("none","descending","ascending"))[[1]]     # Settings                      # Sort order, based on match  
) {
  tryCatch(
    {  
      lazyNut_exec("quietly  match step  reference=dummy stimulus=stimulus stimulus_duration=2")
      if(!("reference" %in% names(df))) {err<-data.frame(error="No reference column in observer df");err$error=as.character(err$error); return(err)}
      y<-sapply(1:length(df[,"reference"]),function (x) grep(df[x,"reference"],colnames(df))[1])
      if (sum(!(is.na(y)))==0) {err<-data.frame(error="Couldn't find reference in vocab");err$error=as.character(err$error); return(err)}
      df$ref.in<-sapply(1:length(df[,"reference"]),function (x) ifelse(is.na(y[x]),NA,df[x,grep(df[x,"reference"],colnames(df))[1]]))
      print(df$ref.in)
      result<-aggregate(ref.in ~ reference+stimulus,df,max)
      result$match<-result$ref.in/(nchar(result$reference)+2*(elm=="TRUE"))
      if (sort.order!="none") result<-result[order(result$match, decreasing = (sort.order=="descending")),]
      result
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
  
}

