function(                                                      # EXTRACT NUMBER OF NODES BEING ACTIVE
  df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame (observer), e.g. (words default_observer)
 activity_threshold=c(0, 0.01, 0.03, 0.05, 0.1, 0.2, 0.5)      # Activity threshold          # Min increase in activity to be considered active
) {
  tryCatch(
    {  
      if (nrow(df) < 1) stop ("input table is empty")
      if ("trial_counter" %in% colnames(df)) stop("this function works for single trials only")
      res = data.frame(activity_threshold = double(),
                       active_units = integer()
                       )  
      df = df[!is.na(df$time), colnames(df) != "time"]
      is.active = function(x, thr) {max(x) - x[1] > thr}
      for (i in 1:length(activity_threshold))
      {
        active_units = apply(df, 2, is.active, thr=activity_threshold[i])
        res = rbind(res, list(
                              activity_threshold = activity_threshold[i],
                              active_units = sum(active_units)
                              ))
      }
      return (res)
    }, warning = function(w) { print(w); 
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
}
