function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR INDIVIDUAL UNITS
  df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame to plot
  node_list=factor(NULL,levels=eN_colnamesplit(df)$levels),  # Exceptions to threshold     # units that will be recorded, regardless of num
  num=0                                           # Dataframe   # Num units to sample
) {
  tryCatch(
    {  
          nodes<-(eN_colnamesplit(df)$levels)
        colMax <- function(data) sapply(data, max, na.rm = TRUE)  
    #      df=read.csv("C:/Users/Davis_Tecra/Google_Drive/easyNetData/easyNet_data/Tests/ia/able.csv")
    #      df$stimulus="door"
        df=na.omit(df)
        if (num>0) samp <- 1 + sample(ncol(df)-2,num) else
          {
            print(node_list)
            samp <- 1+which(nodes %in% node_list)
            print(samp)
          }
        get.sample <- function(df, samp)
        {
          stimulus <- df[nrow(df),"stimulus"]
          samp.df<-df[,samp]
          indexes<-samp-1
          labels<-nodes[indexes]
          df<-data.frame(Stimulus=rep(as.character(stimulus),ncol(samp.df)))
          df$Stimulus=as.character(df$Stimulus)
          df$Label=as.character(labels)
          df$Node=as.numeric(indexes)
          #    print(as.vector(colMax(samp.df)))
          df$MaxVal<-as.vector(colMax(samp.df))
          df$MaxVal<-as.numeric(df$MaxVal)
      #    print(df)
          return(df)
        }
        
        all=data.frame()
        for (s in names(table(df$stimulus)))
          all<-rbind(all,get.sample(subset(df,stimulus==s),samp))
        return(all)
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
  
}
