function(                                                      # SELECT ROWS OF DATAFRAME ON COLUMN VALUE
         df=factor(levels=dataframes(eN))[[1]],        # Dataframe           # data frame to plot
         column=factor(NULL,levels=colnames(df))[[1]],  # Dataframe           # columns to select on
         values=factor(NULL,levels=levels(df[[column]])) # Dataframe           # values to keep
) {
  tryCatch(
    {  
      if(is.null(column)) return(df);
      if(is.null(values)) return(data.frame());
      subset(df,df[[column]]%in%values)
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
}
