function(                                                           # COMPUTE SUMMARY STATISTICS BY CATEGORIES
  df=factor(levels=dataframes(eN))[[1]],                            # Dataframe             # Dataframe with DV(s) and IV(s)
  DV=factor(NULL,levels=colnames(df))[[1]],                          # Variables   # name of column(s) in dataframe to be averaged
  exclude=1000,                                                     # Variables   # exclude trials with values on DV greater than this value
  IVs=factor(NULL,levels=colnames(df)),                        # Variables # IV(s) from df (if any)
  summary=factor("mean",levels=c("mean","sd","var","length","sum","max","min","median","IQR")),      # Statistics            # choose which statistics to calculate
  omit_missing_data=factor("TRUE",levels=c("TRUE","FALSE"))[[1]]    # Statistics            # should missing data be skipped in calculation?
) {
  tryCatch(
    {  
      # watch out for parameter names 
      names(df)<-gsub("::","_",names(df))
      IVs<-gsub("::","_",IVs)
      DV<-gsub("::","_",DV)
      
      df<-reshape(df,direction="long",varying=DV,v.names="y",timevar="set",times=DV)
      y<-"y"
    
      df=df[df[,which(colnames(df)==y)] <= exclude,]
    
      fmla=paste("y","~",ifelse(length(IVs>0),paste(IVs,collapse="+"),1))
      print(fmla)
      
    #  df.summary<-aggregate(as.formula(fmla),data=df,as.symbol(summary[1]),na.rm=as.logical(as.character(omit_missing_data)))
      df.summary<-aggregate(as.formula(fmla),data=df,as.symbol(summary[1]))
      if (ncol(df.summary) == (length(IVs)+1)) names(df.summary)[ncol(df.summary)]<-summary[1]
      if(length(summary)>1) {
        
        for (fun in summary[-1])
        {
    #      tmp<-aggregate(as.formula(fmla),data=df,as.symbol(fun),na.rm=as.logical(as.character(omit_missing_data)))
          tmp<-aggregate(as.formula(fmla),data=df,as.symbol(fun))
          df.summary<-cbind(df.summary,tmp[,-(1:length(IVs))])
          if (ncol(tmp) == (length(IVs)+1)) names(df.summary)[ncol(df.summary)]<-fun
        }
      }
      df.summary
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
      
    }, finally = { 
    
  }
)  
}

  

 