invisible(require(methods,quietly=T))
setClass("eNdataframelist",
         slots=list(dataframes="list",scripts="list",pend="character",names="character"),
         validity=function(object) {
           if(all(sapply(object@dataframes,is.data.frame)))
           {
             if(all(sapply(object@scripts,is.function)))
             {
               for(i in names(object@dataframes)) {
                 nm<-attr(eN@dataframes[[i]],"eN_name")
                 if(nm!=i) return(paste(nm,"does not match",i))
                 if(is.null(nm)) return(paste("name",i,"not set"))
               }
               return(T);
             }
             return("not scripts");
           } 
           return("not data frames");
         }
        )
setMethod("[",
          signature(x="eNdataframelist",i="character"),
          function(x,i,j,drop) {
            eN_read(i);
            x@dataframes[[i]]
          }
         )
setMethod("[<-",
          signature(x="eNdataframelist",i="character",value="data.frame"),
          function(x,i,j,value) {
            eN_read(i);
#print(pending(eN))
#print(c("check",i));
            if(!i%in%dataframes(eN)&!i%in%pending(eN)) {
#print(c("cre ",i))
              lazyNut_exec(paste("create dataframe",i))
            }
            x@dataframes[[i]]<-value;
            attr(x@dataframes[[i]],"eN_name")<-i;
            eN_modification(i);
            eN_read(i);
            x
          }
         )

setGeneric("pending<-",
         def=function(x,value){standardGeneric("pending<-")})
setMethod("pending<-",
          signature(x="eNdataframelist",value="character"),
          function(x,value) {
#            print(value);
            x@pend<-value;
            x
          }
         )

setGeneric("dataframes",
         def=function(x){standardGeneric("dataframes")})
setMethod("dataframes",
          signature(x="eNdataframelist"),
          function(x) {
            names(x@dataframes);
          }
         )

setGeneric("pending",
         def=function(x){standardGeneric("pending")})
setMethod("pending",
          signature(x="eNdataframelist"),
          function(x) {
            x@pend;
          }
         )


eN<-new("eNdataframelist")

eN_colnamesplit<-function(xx){
    name<-paste(attr(xx,"colsplit"),".",sep="");
    x<-colnames(xx); 
    i=nchar(name)
    levelcolb=substring(x,1,i)==name
    if(sum(levelcolb)>0) 
      return(list(name=name,levels=substring(x[levelcolb],i+1),i=i,levelcolb=levelcolb));
    return(list(name="",levels=attr(xx,"colsplit"),i=0,levelcolb=T))
}

eN_colfactor<-function(df,x){
  factor(levels=df[x])
}

evil_parse<-function(x,e=globalenv()) eval(parse(text=x),envir=e)

eN_list_format<-function(l) 
{ 
  if(is.null(l)) return("");
  ret<-character(1); 
  for(i in 1:length(names(l))) { 
    if(substr(names(l)[i],1,1)!="_"&&l[i]!="*"){
      ret[1]<-paste(ret[1],names(l)[i],"=",l[i],"; ",sep="") 
    }
  }; 
  if(dev.cur()!=1) {
    ret[1]<-paste(strwrap(ret[1],dev.size()[1]*12),collapse="\n")
  }
  ret
}

eN_stimulus_set<-function(df)
{
  attributes(df)[["settings"]][["stimulus set"]]
}

eN_model<-function(df)
{
  attributes(df)[["settings"]][["model"]]
}

eN_model_parameters<-function(df)
{
   eN[paste(sep="","(",eN_model(df)," parameters)")]
}

eN_model_parameter<-function(df,par)
{
  val=subset(eN_model_parameters(df),parameter==par)$value
  if(length(val)<1) return(NA);
  val
}

eN_dollar_arg<-function(df)
{
  sett<-attributes(df)$settings
  if(is.null(sett)) return(NULL); 
  wh<-substr(sett,1,1)=="$"
  substr(sett[wh],2,100000)
}

eN_dollar_set<-function(df)
{
  sett<-attributes(df)$settings
  if(is.null(sett)) error("No settings");
  wh<-substr(sett,1,1)=="$"
  names(sett)[wh]
}

eN_name<-function(x)
{
  attr(x,"eN_name")
}