function(                                                      # PLOT MODEL PREDICTED PRIMING AGAINST FPP DATA 
         df=factor(levels=dataframes(eN))[[1]],                             # Settings                      # data frame to plot
         cor.label=factor("top.left",levels=c("top.left","top.right","bottom.left","bottom.right","none"))[[1]],# Settings   # Position of correlation label
         labels=factor("none",levels=c("none","cond","example","residuals"))[[1]],                      # Settings       # Variable containing labels for points  
         plot.type=factor("xyplot",levels=c("xyplot","residuals"))[[1]],    # Settings       # Plot xyplot of data by prediction, or barplot of residuals
         cutoff=7                                                           # Settings       # Cutoff for classifying residuals
) {

  tryCatch(
    {
        require(lattice)
        require(grid)
        
        if (plot.type=="residuals") residuals="TRUE"
        
          if(is.null(eN["fpp.data"])) {
            lazyNut_exec("create stimulus_set fpp.data")  
            lazyNut_exec("fpp.data load Databases/fpp.data.eNd")  
          }
        
        eN["fpp.data"]$PE <- .5*(eN["fpp.data"]$PE.ARB + as.numeric(eN["fpp.data"]$PE.PW))
      
        if (nrow(df) > 26)
        {
            print ("Summarising data")
            
            # compute model prediction condition means
            rt.column<-grep("RT..lexical_decision",names(df))
            print("Determining RT column")
            print(rt.column)
            if (length(rt.column)==0) {plot(0,0,type="n"); return}
            rt.column.lbl<-names(df)[rt.column]
            df1<-aggregate(get(rt.column.lbl) ~ cond, df, mean)
            names(df1)[ncol(df1)]="pred.mean.RT"
            
            # compute predicted priming effects
            df1$pred.pe <- .5* (df1$pred.mean.RT[which(df1$cond=="ALD.ARB")] +
                                df1$pred.mean.RT[which(df1$cond=="ALD.PW")]) -
                                df1$pred.mean.RT
            
            # don't need ALD conditions anymore
            df1<-df1[-grep("ALD",df1$cond),]
        } else { df1<- df ;     print ("data have already been summarised") }
        
      #  print(head(df1))
        df1<-merge(df1,eN["fpp.data"],by.x="cond",by.y="Cond_L")
        print("****************************")
        print(head(df1))
        
        intercept <- 1.0
        lm1 <- lm(I(PE - intercept) ~ 0 + pred.pe, df1)
        df1$pred.pe.rescaled<-lm1$coefficients * df1$pred.pe
        df1$residuals=sprintf("%0.1f",lm1$residuals)
        if (cor.label!="none") { 
          xpos=0.90; ypos=0.05
          if (regexpr("left",cor.label) > -1) xpos=0.10
          if (regexpr("top",cor.label) > -1) ypos=0.95
          cor.text <- paste("rsq =",sprintf("%0.2f",(summary(lm1)$r.squared)^2))
        } else { xpos=0;ypos=0;cor.text=""}
      
        lbls=rep("",nrow(df1))
        plot.marks=c("p","g")
      
        if (labels %in% c("cond","example","residuals"))  { plot.marks=c("g"); lbls=df1[,labels] }
        
      #  write.csv(df1,"rhubarb.csv")
        
        if  (plot.type=="xyplot")
        {
          
          min.xy <-min(c(df1$PE,df1$pred.pe.rescaled)) - 5
          max.xy <-max(c(df1$PE,df1$pred.pe.rescaled)) + 5
          
          mypanel<-function(x,y,...){
            panel.xyplot(x, y, ...)
            grid.text(cor.text, unit(xpos, 'npc'), unit(ypos, 'npc'), gp=gpar(fontsize=20))
            #    panel.text(scm$x.rescaled,scm$RT,scm$cond )
            panel.text(df1$pred.pe.rescaled,df1$PE,lbls)
            panel.abline(a=0,b=1)
          }
      
          
          plt<-xyplot(PE ~ pred.pe.rescaled,df1,type=plot.marks,panel=mypanel,
                      ylim=c(min.xy,max.xy),xlim=c(min.xy,max.xy),
                      xlab="Scaled predicted priming effect (ms)",
                      ylab="Observed priming effect (ms)")
          
      #     library(ggplot2)
      #     library(ggrepel)
      #     set.seed(42)
      #     
      #     plt <- ggplot(df1, aes(pred.pe.rescaled, PE)) +
      #       geom_point(color = 'red') +
      #       theme_classic(base_size = 10)
      #     plt<- plt + geom_text(aes(label = df1$lbls),
      #                   size = 3.5)
      #     plt<- plt + geom_text_repel(aes(label = df1$lbls),
      #                         size = 3.5) 
          
        } else
        
        {  
          require(ggplot2)
          print("Residuals"); print (df1$residuals)
          df1$residuals<- -1 *  as.numeric(df1$residuals)
          # df1$colour <- ifelse(df1$residuals > cutoff, "firebrick1", (ifelse(df1$residuals < -1*cutoff, "steelblue", "black")))
          df1$colour <- "#A4A4A4"
          df1$colour[df1$residuals > cutoff] = "#FF0000"
          df1$colour[df1$residuals < -1*cutoff] = "#56B4E9" # "steelblue"
          df1$fsize <- ifelse(abs(df1$residuals) > cutoff, 6,4)
          df1$fface <- ifelse(abs(df1$residuals) > cutoff, 2, 1) #"bold","normal")
          df1$hjust <- ifelse(df1$residuals > 0, 1.3, -0.3)
          print(head(df1))
          plt <- ggplot(df1, aes(cond, as.numeric(residuals), label = cond,
                          hjust = hjust)) + geom_text(aes(y = 0), size=df1$fsize, fontface=df1$fface, colour=df1$colour) + 
                          geom_bar(stat = "identity",position = "identity",aes(fill = colour))
          plt <-  last_plot() + coord_flip() + labs(x = "", y = "") + theme(legend.position="none")
          plt <- plt + scale_fill_manual(values=c("#56B4E9", "#A4A4A4",  "#FF0000" ))
          # plt <- plt + theme_bw()
          plt <- plt + theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank())
        }
        
        print (plt)
      
        if  (plot.type=="residuals") { 
            grid.text("Underestimates", unit(.35, 'npc'), unit(.025, 'npc'), gp=gpar(fontsize=16,col="#56B4E9"))
            grid.text("Overestimates", unit(.8, 'npc'), unit(.025, 'npc'), gp=gpar(fontsize=16,col="#FF0000")) 
        }
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
      
    }
  )
  
}  
