function(                                                      # PLOT TARGET BY COMPETITOR ACTIVITY/STATE 
         df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame to plot
         node=factor(NULL,levels=eN_colnamesplit(df)$levels), # Pick target node               # specify target node
         type=2,                                                 # Plot_Type   # 1=points, 2=lines
         min.y=99.00/1.00,                                       # Cosmetic # lower limit on y-axis, 99=min val in df
         max.y=99.00/1.00                                        # Cosmetic # upper limit on y-axis, 99=max val in df
) {
  tryCatch(
    {
      
      
    #  write.csv(0,"debug.csv")
      cols<-eN_colnamesplit(df)
      if (length(node)<1)     node <- cols$levels[1]
    
      target <- df[,1+which(cols$levels==node)]
    #  write.csv(target,"target.csv")
      comp <- df[,which(c("",cols$levels)!=node)]
      comp <- comp [,-c(1)]
     write.csv(comp,"comp.csv")
     
      comp.sum <- rowSums(comp * (comp > 0))
       
       ptype<-c("p","l","n")
    
      plt <-   plot(comp.sum,target,
                          xlab="Competitor activity",
                          ylab="Target Activity",
                          main=paste("Competitor plot: target =", node),
                          #ylim=c(min.y,max.y),
                          pch=16, #,
                          type=ptype[type]
                    )
      
      plt <- grid()
                     
      print (plt)
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
      
    }
  )
  
}
