function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR INDIVIDUAL UNITS
         df=factor(levels=dataframes(eN))[[1]],                           # Settings                      # data frame to plot
         max_dis=.5,                                                      # Settings                      # match values lower than 1 minus this threshold will not be included
         end_letter_marking=factor("TRUE",levels=c("TRUE","FALSE"))[[1]], # Settings                      # If end_letter_marking is true, 2 will be added to maximum match value
         font_size=5                                                      # Settings                      # font size for labels
) {
#  interval_angle=30,                                    # Dataframe                      # interval between spokes (purely aesthetic)
  tryCatch(
    {
      
      #  write.csv(df,"df.csv")
      require(ggplot2)
      
      cycle = nrow(df)
      cols<-eN_colnamesplit(df)
      
      m1 = nchar(as.character(cols$levels))
      if (end_letter_marking=="TRUE") m1 <- m1+2  # assumes ELM
      if ("time" %in% names(df)) df$time=NULL
      m2=as.vector(t(df[cycle,])) # [-1]
      d = (m1 - m2)/m1
    #  write.csv(cols,"cols.csv")
      match=data.frame(m1=m1,m2=m2,d=round(d,4))
      match$word=cols$levels
      match=subset(match,d<max_dis)
      dist.table<-table(match$d)
      match<-match[order(match$d,decreasing=F),]
      match$ang<-rep(NA,nrow(match))
      rown<-1
       for (di in 1:length(dist.table))
      {
        num<-dist.table[di]
        if ((rown+num-1)>nrow(match)) num<- nrow(match) - rown + 1
        match$ang[rown:(rown+num-1)]<-seq(di*360/length(dist.table),by=360/num,length.out=num)[1:num]
        rown<-rown + num
        
      }
     #      match$ang=sample(seq(0,by=interval_angle,length.out=nrow(match)) %% 360)
      #  write.csv(match,"match.csv")
    
      polar2cart<-function(dist,bearing){
        ## Translate Polar coordinates into Cartesian coordinates
        bearing=bearing*pi/180
        newx<-dist*sin(bearing)  ##X
        newy<-dist*cos(bearing)  ##Y
        return(list("x"=newx,"y"=newy))
      }
      
      match$x = (polar2cart(match$d,match$ang))[["x"]]
      match$y = (polar2cart(match$d,match$ang))[["y"]]
    #  write.csv(match,"match2.csv")
      
      theta=seq(from=0,by=.01,to=2*pi)
      ncirc=10
      
      dat.circ = do.call(rbind,
                         lapply(seq_len(ncirc),function(n){
                           r <- n*max_dis/ncirc
                           data.frame(x=r*sin(theta),y=r*cos(theta),r=round(r,2))
                         }))
      rr <- unique(dat.circ$r)
      
      dat.text=data.frame(x=rr*cos(30),y=rr*sin(30),label=rr)
      
#      print("about to throw error"); error
      print(ggplot(match,aes(x,y))+
        geom_point() +
        ggtitle(paste(nrow(match),"nodes within radius of",format(max_dis,digits=2))) +
        geom_path(data=dat.circ,alpha=.2,linetype=2,aes(group=factor(r))) +  
        geom_text(data=match,aes(label=word),size=font_size,vjust=-.5) + theme_bw()
           )       
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
      
    }
  )
  
  
}
