function(                                                      # PLOT IA-STYLE LETTER FEATURES
         df=factor(levels=dataframes(eN))[[1]],                  # Settings   # data frame to plot
         cycle=factor("0",levels=df["time"])[[1]]                # Settings   # Which cycle to plot
) {
  ###############################
  # This R script plots the activation of the feature level in a way that reproduces the font in Fig. 4 in McClelland & Rumelhart 1981.
  # If a feature is ambiguous (present=1 and absent=1), it is plotted as dashed line
  # Reads in a verbose observer for the feature level (.eN.file.DATA).
  # Requires the user to specify which cycle will be plotted (.eN.int.CYCLE), by default plots the first one.
  
  tryCatch(
    {    
        df = df[!is.na(df$time),]
        df = df[,order(colnames(df))]
        if (is.nan(cycle)) { row<- which(is.nan(df$time))[1]; print (paste("found nan: choosing row",row)) } else 
        if (grepl("NAN",cycle)) { row<- which(grepl("NAN",df$time))[1]; if (is.na(row)) row<-1; print (paste("found NAN: choosing row",row)) } else row <- which(df$time==cycle)[1]
        feature = as.numeric(df[row,])
        
        
        x0 = 0
        y0 = 0
        slots=floor(ncol(df)/(14*2))
        print("plotting features")
        
        # attach feature names to feature
        fv=c(
        
        "10A","10P","11A","11P","12A","12P","13A","13P","14A","14P",
        "1A","1P","2A","2P","3A","3P","4A","4P","5A","5P",
        "6A","6P","7A","7P","8A","8P","9A","9P")
        fn=NULL
        for (i in 0:(slots-1)) fn = rbind(fn,paste0(fv,"/",i))
        feature_names = make.names(fn)
        feature = data.frame(matrix(feature,nrow = 1))
        colnames(feature) = feature_names
        
        # graphic parameters
        
        LX = 1.0 # letter width
        LY = 1.4 # letter heigth
        FRAME = 0.05 # fraction of LX,LY used as frame. Each letter is contained in a frame of dimensions (1+2*FRAME)*LX times (1+2*FRAME)*LY
        SCALE = 1 # a scale factor, not used
        
        LX = SCALE * LX
        LY = SCALE * LY
        LY3 = SCALE * LY
        LY2 = SCALE * LY * .6667
        LY1 = SCALE * LY * .3333  
        
        
        # define coordinates for each feature segment, a line from (x1,y1) to (x2,y2)
        FC = list()
        FC[[1]] = 	list(x1 = 0, y1 = 0, x2 = 0, y2 = LY/2)
        FC[[2]] = 	list(x1 = 0, y1 = LY/2, x2 = 0, y2 = LY)
        FC[[3]] = 	list(x1 = 0, y1 = LY, x2 = LX, y2 = LY)
        FC[[4]] = 	list(x1 = LX, y1 = LY/2, x2 = LX, y2 = LY)
        FC[[5]] = 	list(x1 = LX, y1 = 0, x2 = LX, y2 = LY/2)
        FC[[6]] = 	list(x1 = 0, y1 = 0, x2 = LX, y2 = 0)
        FC[[7]] = 	list(x1 = 0, y1 = LY/2, x2 = LX/2, y2 = LY/2)
        FC[[8]] = 	list(x1 = LX/2, y1 = LY/2, x2 = LX/2, y2 = LY)
        FC[[9]] = 	list(x1 = LX/2, y1 = LY/2, x2 = LX, y2 = LY/2)
        FC[[10]] = 	list(x1 = LX/2, y1 = 0, x2 = LX/2, y2 = LY/2)
        FC[[11]] = 	list(x1 = 0, y1 = LY, x2 = LX/2, y2 = LY/2)
        FC[[12]] = 	list(x1 = LX/2, y1 = LY/2, x2 = LX, y2 = LY)
        FC[[13]] = 	list(x1 = LX/2, y1 = LY/2, x2 = LX, y2 = 0)
        FC[[14]] = 	list(x1 = LX/2, y1 = LY/2, x2 = 0, y2 = 0)
      
        plot(x0 + c(0,slots*LX*(1+2*FRAME)),y0 + c(0,LY)*(1+2*FRAME), type='n', xlab='', ylab='',axes=F, main = paste('Feature-level activity at cycle',cycle),cex.main=1.5)
        # plot frames
        lines(x0 + c(0,slots*LX*(1+2*FRAME)),y0 +  rep(y0,2), col = 'black',lwd=1) # bottom
        lines(x0 + c(0,slots*LX*(1+2*FRAME)),y0 +  rep(LY*(1+2*FRAME),2), col = 'black',lwd=1) #top
        for (l in 0:(slots)) { lines(  x0 + rep( l*(LX*(1+2*FRAME)), 2), y0 + c(0,LY*(1+2*FRAME)), col = 'black',lwd=1) } # verticals
        
        # plot letters
        for (l in 0:(slots-1)) {
          for (f in 1:14) {
            if 	(feature[[paste0('X',f,'P','.',l)]] & !feature[[paste0('X',f,'A','.',l)]])
            { lty = 1; print (f) } # feature present, plot it as solid line
            else if (!feature[[paste0('X',f,'P','.',l)]] & !feature[[paste0('X',f,'A','.',l)]])
            { lty = 2 } # feature ambiguous (present=1 and absent=1), plot it as dashed line
            #JSA feature ambiguous is present=0 and absent =0 per pg 224 of McClelland and Rumelhart (1988) EPDP book
            else 
            { lty = 0 } # feature absent or both present=0 and absent=0, do not plot it	
            lines(x0 + (LX*(1+2*FRAME))*l + LX*FRAME + c(FC[[f]]$x1,FC[[f]]$x2), y0 + LY*FRAME + c(FC[[f]]$y1,FC[[f]]$y2), col='blue',lwd=4,lty=lty)
            
          }
        }
    }, warning = function(w) { print(w); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, error = function(e) { print(e); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, finally = { print ("done"); # plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")
      
    }
  )
}
