function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR A SPATIAL LAYER
         df=factor(levels=dataframes(eN))[[1]],                # Settings                     # data frame to plot
         times=factor("3",levels=c("5","10","15","20","25","30"))               # Settings                     # Time slices to plot
#         num_slices=1                                         # Settings                     # Number of time slices to plot
#         time_interval=100                                    # Settings                     # Time interval between plots
) {
  require(lattice)

  nr<-nrow(df) - 2
#  time_interval = round(nr / num_slices)
#   if (time_interval < 1)
#     time_interval = 10
  cols<-eN_colnamesplit(df)$levels
  cols<-c("",cols) # adjust for time column
  sigma=.6
  scaler = dnorm(0,0,sigma)



#  df<-df[time_interval*(1:(nr/time_interval)),]
  #times=c(2,5,10,15,20)
  write.csv(times,"times.csv")
  times=as.numeric(times)
  write.csv(times,"times2.csv")
#  times=time_interval*(1:(nr/time_interval))
  df<-df[times,]
  
  widget<-  
    function(ex) { 
      ntimes=length(ex); 
      l<-(-10):90/10; 
      temp<-sapply(ex,function(x)
                   {
                     if(length(x)==0) return(rep(0,length(l)));
                     apply(sapply(x,function(y) y[2]*dnorm(l,y[1],sigma)/scaler),1,sum)
                   }
                  ); 
      data.frame(height=as.vector(temp),
#                 location=rep(l,times=ntimes),time=rep(1:ntimes,each=length(l))) 
                 location=rep(l,times=ntimes),time=rep(times,each=length(l))) 
  }
  
  d<-data.frame(height=NULL,location=NULL,time=NULL,title=NULL)

  for(i in 1:length(cols)) {
    if(sum(unlist(df[,i]))>0){
      d<-rbind(d,
               cbind(
                 widget(df[,i]),
                 data.frame(title=cols[i])
                )
              )
    }
  }
  
#  write.csv(d,"df.csv")
  d=na.omit(d)
  time.label = paste("time =",d$time)
  d=cbind(d,data.frame(factor(time.label,levels = unique(time.label))))
  names(d)[ncol(d)]="time.label"

#  my.settings <- canonical.theme(color=FALSE)
  my.settings <- canonical.theme()
  my.settings[['strip.background']]$col <- "black"
  my.settings[['strip.border']]$col<- "black"
  my.settings[['background']]$col<- "white"
  my.settings[['axis.text']]$cex<-0.9 # doesn't do anything?
  print(xyplot(height~location|time.label, 
         groups=title, 
         data=d, 
         as.table=TRUE, 
         ylim=c(0, 1.3),          
         scales=list(cex=c(1.1, 1.1), # increase font size
                     alternating=1,   # axes labels left/bottom 
                     tck = c(1,0)),   # ticks only with labels
         par.settings = my.settings, 
#         cex=1.1, # change size of symbols 
         #cex=0.9, # change size of symbols
         cex.font="Georgia",
         xlab=list(label="Location", fontsize=14),
         ylab=list(label="Amplitude", fontsize=14),
         par.strip.text=list(col="white", font=2),
         panel=panel.superpose,
         panel.groups=function(x,y, group.number,...){           
           panel.xyplot(x,y,t="l",...) 
           panel.grid(v=-1, h=-1, lty=3)
           xt <- x[which(y==max(y) & y>0)[1]] 
           yt <- y[which(y==max(y) & y>0)[1]]+.2          
           panel.text(xt, yt, labels=levels(d$title)[group.number], fontsize=24,  
                      ...)
         }              
  ))
}
