function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR INDIVIDUAL UNITS
         df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame to plot
         sample=17                                                # Dataframe              # show every nth
) {
  require(lattice)
  
  xn<-colnames(df)[2]

  yspot<-numeric(nrow(df))
  in1<-df[,1]
  in2<-list()
  for(i in 1:nrow(df)) {
    c1<-do.call(paste,c(sep=" ",lapply(df[i,2:ncol(df)],function(x) if(length(x[[1]])>0) x[[1]][[1]] else "")))
    c1<-sub(" *$","",c1)
    c1<-sub("%([^ ]*)%","(\\1)",c1)
    c1<-sub(":([^ ]*)( |$)","[\\1] ",c1)
    c1<-sub("\\.","?",c1)
    c2<-unlist(lapply(df[i,2:ncol(df)],function(x) if(length(x[[1]])>1) c(x[[1]][[2]],x[[1]][[2]][1]) else NULL))
    yspot[i]<-mean(c2)
    in2[[i]]<-list(c1,c2)
  }

  in1<-in1[1:length(in1)%%sample==0]
  in2<-in2[1:length(in2)%%sample==0]

  mcex=150/max(df["time"],na.rm=T)
  if(mcex>2) mcex=2
  print(xyplot(
      yspot~time,df,
      ylab="Strength",
#      scales=list(y=list(at= c() )),
      panel=function(x,y) {#yn=jitter(rep(1,dim(df)[1]),20);
      mapply(
        function(xo,yo)
        {
          xhold<-NULL; yhold<-NULL
          yi<-unlist(strsplit(yo[[1]],""))
          for(i in 1:length(yi))
          {
            jit=350*(i-.5-length(yi)/2)/(mcex*max(df["time"],na.rm=T))
            panel.text(xo+jit,yo[[2]][i],yi[i],cex=mcex,col=(xo%%4)+1,fontfamily="Courier")
              xhold<-c(xhold,xo+jit); yhold<-c(yhold,yo[[2]][i]-mcex/100);
            
          }
          panel.xyplot(xhold[yi!="_"],yhold[yi!="_"],type="l",col=(xo%%4)+1)
#          panel.text(xhold[yi!="_"],yhold[yi!="_"]+mcex/20,"_",col=(xo%%4)+1,cex=mcex)
        }
        ,in1,in2);
      panel.xyplot(x,y,type="l",col="grey"); 
      }
    )
  )
}
