function(                                                        # BASIC XY PLOT
         df=factor(levels=dataframes(eN))[[1]],                  # Data       # data frame to plot
         xvar=factor(NULL,levels=colnames(df))[[1]],             # Data       # Variable to plot on x-axis  
         yvar=factor(NULL,levels=colnames(df))[[1]],             # Data       # Variable to plot on y-axis  
         groups=factor(NULL,levels=colnames(df))[[1]],           # Data       # Grouping variable   
         panels=factor(NULL,levels=colnames(df))[[1]],           # Data       # Plot multiple panels
         labels=factor(NULL,levels=colnames(df))[[1]],           # Labels       # Variable containing labels for points  
         residuals=factor("FALSE",levels=c("TRUE","FALSE"))[[1]],           # Labels       # Plot residuals as labels  
         cor.label=factor("top.left",levels=c("top.left","top.right","bottom.left","bottom.right","none"))[[1]],# Labels   # Position of correlation label
         scale.xvar=factor("FALSE",levels=c("TRUE","FALSE"))[[1]],# Scale   # Scale x-variable to y
         log.scale=factor("FALSE",levels=c("TRUE","FALSE"))[[1]],# Scale   # Plot y-axis using log scale
         type=factor("p,g",levels=c("p","l","h","b","o","s","S","r","a","g","smooth","spline")), # Cosmetic   # Plot type (see https://stat.ethz.ch/R-manual/R-devel/library/lattice/html/panel.xyplot.html)
         min.x=.0/.0,                                            # Cosmetic   # lower limit on x-axis
         max.x=.0/.0,                                            # Cosmetic   # upper limit on x-axis
         min.y=.0/.0,                                            # Cosmetic   # lower limit on y-axis
         max.y=.0/.0                                             # Cosmetic   # upper limit on y-axis
) {
  tryCatch(
    {
      
      require(lattice)
      require(grid)
      df <-na.omit(df)
      log.scale=as.logical(as.character(log.scale))
#      panels<-as.character(panels)
      print("line 26")
      if(!is.null(panels))
     {
        print ("panels")
        print (panels)
#       df[panels]<-ordered(df[[panels]],levels=unique(df[[panels]]))
     }
    
      #cols<-eN_colnamesplit(df)
      print("line 33")
      cols<-data.frame(levels=names(df))
      print("line 34")
      
      colors=1
#      if (!is.null(groups) & groups!="") colors=1:length(table(df[,groups])) else colors=1
#      if (!is.null(groups)) colors=1:length(table(df[,groups])) else colors=1
      
      # make sure x-axis is numeric
      print(df[,xvar])
      df[,xvar] <- as.integer(as.character(df[,xvar]))
      
      print(xvar)
      print(yvar)
      print("line 38")
      
      fmla<-paste0("get('",yvar,"') ~ get('",xvar,"')")
      print(fmla)
      
      lm1<-lm(fmla,data=df)
      if (residuals=="TRUE") {labels="resid"; df$resid=sprintf("%0.1f",lm1$resid)}
      if(scale.xvar) {
        xvar.rescaled<-paste0(xvar,".scaled")
        df$x.rescaled<-lm1$coefficients[1] + lm1$coefficients[2] * df[,xvar]
        names(df)[ncol(df)]<-xvar.rescaled
        xvar<-xvar.rescaled
        fmla<-paste0("get('",yvar,"') ~ get('",xvar,"')")
      }
      lbls=rep("",nrow(df))
      if (! is.null(labels)) {
        if(nchar(labels)>0) lbls=df[,labels]
      }
      print("line 55")
      eminx=min(df[,xvar])
      emaxx=max(df[,xvar])
      eminy=min(df[,yvar])
      emaxy=max(df[,yvar])
      if(is.na(min.x))
        min.x=1.05*eminx-.05*emaxx
      if(is.na(max.x))
        max.x=1.05*emaxx-.05*eminx
      if(is.na(min.y))
        min.y=1.05*eminy-.05*emaxy
      if(is.na(max.y))
        max.y=1.05*emaxy-.05*eminy
      if(min.x==max.x)
      {
        min.x=1.05*eminx-.05*emaxx
        max.x=1.05*emaxx-.05*eminx
      }
    #   if(min.x==max.x)
    #   {
    #     min.x=0;
    #     max.x=1;
    #   }  
      if(min.y==max.y)
      {
        min.y=1.05*eminy-.05*emaxy
        max.y=1.05*emaxy-.05*eminy
      }
    #   if(min.y==max.y)
    #   {
    #     min.y=0;
    #     max.y=1;
    #   }
      if ((log.scale)&&(min.y<=0)) min.y=0.001
      
      print("line 91")
      
      
      if(!is.null(panels)) {
        if((length(panels)>0) & panels!="") fmla <-paste0(fmla,"|",panels)
      }
      print(lbls)
      
      print(fmla)
      
      if (cor.label!="none") { 
        xpos=0.90; ypos=0.05
        if (regexpr("left",cor.label) > -1) xpos=0.10
        if (regexpr("top",cor.label) > -1) ypos=0.95
        cor.text = paste0("r=",sprintf("%0.3f",cor(df[,xvar],df[,yvar])))
          mypanel<-function(x,y,...){
            panel.xyplot(x, y, ...)
            grid.text(cor.text, unit(xpos, 'npc'), unit(ypos, 'npc'), gp=gpar(fontsize=20))
              panel.text(df[,xvar],df[,yvar],lbls)
          }
      } else
        mypanel<-function(x,y,...){
          panel.xyplot(x, y, ...)
          panel.text(df[,xvar],df[,yvar],lbls)
        }
      
      if (!is.null(groups)) 
      { print("GROUPS"); print(groups)
        print(xyplot(
                   as.formula(fmla),
                   groups=df[[groups]],
                   scales=list(y=list(log=log.scale, equispaced.log = FALSE)),
                   type=type,
#                   pch=16,
                   data=df,
                   main=cols$name,
                   xlab=xvar,
                   ylab=yvar,
                   col=colors, 
    #                key=list(text=list(names(table(df[,groups]))),
    #                         points=list(col=colors),
    #                         space="right"
    #                        ),        
                    xlim=c(min.x,max.x),
                    ylim=c(min.y,max.y),
    #                as.table=T
                   sub=eN_list_format(attr(df,"settings"))
                  )
           )
      } else {
#        print("HERE"); print(cor.label)
                  print(xyplot(
                    as.formula(fmla),
                    panel=mypanel,
                    scales=list(y=list(log=log.scale, equispaced.log = FALSE)),
                    type=type,
                    data=df,
                    main=cols$name,
                    xlab=xvar,
                    ylab=yvar,
                    #                key=list(text=list(levels(factor(pdat$unit))[leveling]),
                    #                         lines=list(col=colors[leveling]),
                    #                         space="right"
                    #                        ),        
                    xlim=c(min.x,max.x),
                    ylim=c(min.y,max.y),
                    #                as.table=T
                    sub=eN_list_format(attr(df,"settings"))
                  )
                  
                  
          )
      }
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
    
    }
  )
}
