#include "alt.hpp"
#include "ustate.hpp"
#include "probs.hpp"
#include "func.hpp"
#include <string>
#include <vector>
#include <fstream>
#include <iostream>

void quotestrip(std::string&s)
{
  if(s[0]!='\"') return;
  int n=s.length();
  if(s[n-1]!='\"') return;
  s=s.substr(1,n-2);
}


int main(int argc,char**argv)
{
  std::string type;
  std::string parsf,desif,resuf;

  if(argc<2)
  {
    std::cerr<<"Do you want prime, id, or help?\n";
    std::getline(std::cin,type);
  }
  else type=argv[1];
  
  if(type!="prime"&&type!="id"&&type!="help")
  {
    std::cerr<<"\"help\", \"prime\" and \"id\" are valid options\n.";
    std::cerr<<"I guess you need help.\n";
    type="help";
  }

  if(type=="help"||argc>5)
  {
    std::cerr<<"Run from command line, with 4 parameters (if run with no parameters, will prompt for them):\n";
    std::cerr<<"For PRIMING:\n";
    std::cerr<<argv[0]<<" prime paramfile inputfile outputfile\n";
    std::cerr<<"prime means literally the word prime\n";
    std::cerr<<"paramfile should be the name of a file containing alpha sigma lambda o eta B in that order\n";
    std::cerr<<"inputfile should be rows of target relatedprime unrelatedprime duration\n";
    std::cerr<<"outputfile should be the name of the file you'd like filled with rows from inputfile with an extra column of containing PRIMING\n\n";
    std::cerr<<"For IDENTIFICATION:\n";
    std::cerr<<"THIS GIVES P(KNOWN) NOT P(CORRECT) !!!\n";
    std::cerr<<argv[0]<<" id paramfile inputfile outputfile\n";
    std::cerr<<"id means literally the word id\n";
    std::cerr<<"paramfile should be the name of a file containing alpha sigma lambda eta beta1 beta2 etc... in that order\n";
    std::cerr<<"inputfile should be rows of target foil duration\n";
    std::cerr<<"outputfile's should be the name of the file you'd like filled with rows from inputfile with an extra column of containing proportion KNOWN\n";
    std::cerr<<"Additional calculations are needed to include guessing.\n";
    std::cerr<<"Run different target lengths separately if you want different betas for each length.\n\n";
    std::cerr<<"Press enter.\n";
    std::string s;
    std::getline(std::cin,s);
    exit(5);
  }
  
  if(argc<3)
  {
    std::cerr<<"Which parameter file?\n";
    std::getline(std::cin,parsf);
    quotestrip(parsf);
  }
  else parsf=argv[2];
  
  
  if(argc<4)
  {
    std::cerr<<"Which design file?\n";
    std::getline(std::cin,desif);
    quotestrip(desif);
  }
  else desif=argv[3];
  
  if(argc<5)
  {
    std::cerr<<"Where do you want the results to go?\n";
    std::getline(std::cin,resuf);
    quotestrip(resuf);
  }
  else resuf=argv[4];
  
  std::ifstream pars(parsf.c_str());
  std::ifstream desi(desif.c_str());
  std::ofstream resu(resuf.c_str());

  if(!pars||!desi||!resu)
  {
    std::cerr<<"File error.\n";
    std::cerr<<"Press enter.\n";
    std::string s;
    std::getline(std::cin,s);
    exit(10);
  }
  
  std::vector<double> allpars;
  double x;
  while(pars>>x)
  {
  
    allpars.push_back(x);
  }

  std::vector<std::string> vtars,vpris,vcons;
  std::vector<double> vdurs;
  std::string t,r,u;
  double d;
  if(type=="prime")
  {
    while(desi>>t>>r>>u>>d)
    {
      vtars.push_back(t);
      vpris.push_back(r);
      vcons.push_back(u);
      vdurs.push_back(d);
    }
  }
  else //if(type=="id")
  {
    while(desi>>t>>r>>u>>d)
    {
      vtars.push_back(t);
      vpris.push_back(r);
      vdurs.push_back(d);
    }
  }

  int n=vtars.size();
  double* pk=new double[n];
  const char** tars=new const char*[n];
  const char** pris=new const char*[n];
  const char** cons=new const char*[n];
  double* ti=new double[n];

  for(int i=0;i<n;++i)
  {
    tars[i]=vtars[i].c_str();
    pris[i]=vpris[i].c_str();
    if(type=="prime") cons[i]=vcons[i].c_str();
    ti[i]=vdurs[i];
  }

  if(type=="prime")  prime_vector_ml2(pk,allpars.data(),pris,tars,cons,ti,&n);
  else /*if(type=="id")*/ pk_vector(pk,allpars.data(),pris,tars,ti,&n);
  
  for(int i=0;i<n;++i)
  {
    resu<<tars[i]<<"\t"<<pris[i]<<"\t";
    if(type=="prime") resu<<cons[i]<<"\t";
    resu<<ti[i]<<"\t"<<pk[i]<<"\n";
  }
}
